<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Question extends Model 
{

    protected $table = 'questions';
    public $timestamps = true;
    protected $fillable = array('language_key', 'category_id', 'question_type', 'image_id', 'module', 'parent_question_id', 'question_en', 'question_ind', 'question_malay', 'question_thai', 'question_urdu', 'question_burmese', 'question_rohingya', 'question_dari', 'question_somali', 'question_arabic', 'status');

    public function category()
    {
        return $this->belongsTo('App\Models\Category', 'category_id');
    }

    public function image()
    {
        return $this->belongsTo('App\Models\Image', 'image_id');
    }

    public function answers()
    {
        return $this->hasMany('App\Models\Answer', 'question_id', 'id');
    }

    public function subQuestionLogic()
    {
        return $this->hasOne('App\Models\SubQuestionLogic', 'sub_question_id', 'id');
    }

    public function subQuestions()
    {
        return $this->hasMany('App\Models\Question', 'parent_question_id');
    }

    public function parentQuestion()
    {
        return $this->hasOne('App\Models\Question', 'id', 'parent_question_id');
    }

}